﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.School
{
    public partial class UCSchoolDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.School, BL.BO.School.Search>
    {
        private const int _IndexTabExerciseAvatar = 0;
        protected     int _IndexTabSystemInformation        = 1;
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabSchoolDetails _tabSchoolDetails = null;

        public UCTabSchoolDetails TabSchoolDetails
        {
            get
            {
                if (_tabSchoolDetails == null)
                {
                    _tabSchoolDetails = new UCTabSchoolDetails();
                }
                return _tabSchoolDetails;
            }
        }

        protected internal PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCSchoolDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabExerciseAvatar, TabSchoolDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabSchoolDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabSchoolDetails.Save();
            _methodResult = BLZSBELearning.School.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.School _School = BLZSBELearning.School.Restore(ID);
            if (_School != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _School);
                TabSchoolDetails.Restore();

                this.CreateToolbarActions();
            }

            return _result;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            if (DataManager.Current != null)
            {
                List<BL.BO.Student> _listStudent = BLZSBELearning.Student.Restore(DataManager.Current);
                List<BL.BO.Class> _listClass = BLZSBELearning.Class.Restore(DataManager.Current);
                List<BL.BO.Instructor> _listInstructor = BLZSBELearning.Instructor.Restore(DataManager.Current);

                ProcessStart(ProcessingType.Remove, _listStudent.Count + _listClass.Count + _listInstructor.Count + 1);

                foreach (BL.BO.Student _loopStudent in _listStudent)
                {
                    _methodResult.Add(BLZSBELearning.Student.Remove(_loopStudent));
                    Process();
                }

                foreach (BL.BO.Class _loopClass in _listClass)
                {
                    _methodResult.Add(BLZSBELearning.Class.Remove(_loopClass));
                    Process();
                }

                foreach (BL.BO.Instructor _loopInstructor in _listInstructor)
                {
                    _methodResult.Add(BLZSBELearning.Instructor.Remove(_loopInstructor));
                    Process();
                }

                if (_methodResult.Success == true)
                {
                    _methodResult.Add(BLZSBELearning.School.Remove(DataManager.Current));
                }

                Process();
            }
            return _methodResult;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;

            if (DataManager.Current != null)
            {
                FRemoveSchool _dialog = Gemini.Core.WinForms.Base.Form.Create<FRemoveSchool>(this.Plugin, Environment);
                _dialog.Initialize(DataManager.Current, Plugin, Environment);

                if (DialogResult.OK == _dialog.ShowDialog())
                {
                    _return = true;
                }
                else
                {
                    _return = false;
                }
            }
            return _return;
        }
    }
}
